# coding: utf-8
#----------------------------------------------------------------------------------------
# ARIVIS AG
# SCRIPT description
# DATA : 20/04/2019
# REVISION : 1.00
# WRITTEN BY : Maurizio Abbate
# PURPOSE : the whole volume is divided in contiguos boxes
#           
#           
# NOTES: 
#
# Tested for V4d Release : 3.1.4
#
# NOTE: 2020-04-05  CORREGGERE ERRORE, SE NON CI SONO OGGETTI NON FUNZIONA
#
# ------------------------------ External Package Import ------------------------------ 
import time
import arivis
import arivis_core as core
import arivis_objects as objects
# ------------------------------  End of external Package Import ------------------------------ 
#
# @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ USER SETTINGS @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
#
#----------------------------------------------------------------------------------------
# SIZE_BOX_X,SIZE_BOX_Y,SIZE_BOX_Z expressed in um
# SIZE_BOX_? must be calibration factor * MINIMUM_SIZE_BOX_COEFF (at least)
#----------------------------------------------------------------------------------------
SIZE_BOX_X = 500.0
SIZE_BOX_Y = 500.0
SIZE_BOX_Z = 500.0
MINIMUM_SIZE_BOX_COEFF = 1.0
# @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ END OF USER SETTINGS @@@@@@@@@@@@@@@@@@@@@@@@@@@@@
#
# ------------------ Global variables DON'T MODIFY THE FOLLOWING VARIABLES -------------------- 
BOX_X = 0
BOX_Y = 1
BOX_Z = 2
# ------------------------------ End of global variables ------------------------------ 
#
# ------------------------------ Script body ------------------------------ 
# PLEASE DON'T MODIFY THIS CODE SECTION WITHOUT THE KNOWLEDGE OF PYTHON PROGRAMMING
# ------------------------------------------------------------------------------
#
# ------------------------------ Script body ----------------------------------- 
# Function : Get_Enviroment
# ------------------------------------------------------------------------------
def MA_Get_Enviroment():
  # ------------------------------------------------------------------------------
  # return the viewer and the imageset  objects
  # ------------------------------------------------------------------------------
  viewer = arivis.App.get_active_viewer()
  imageset = viewer.get_imageset()
  if None == imageset :
    print "No Image Set open" 
    return viewer,None  
  # ------------------------------------------------------------------------------ 
  return viewer,imageset
# ------------------------------ Script body ----------------------------------- 
# End Function : MA_Get_Enviroment
# ------------------------------------------------------------------------------ 
# ------------------------------ Script body ----------------------------------- 
# Function : MA_Get_Storage
# ------------------------------------------------------------------------------
def MA_Get_Storage(imageset):
  # ------------------------------------------------------------------------------
  # return the storage object
  # ------------------------------------------------------------------------------
  if None == imageset :
    print "No Image Set open" 
    return None  
  # ------------------------------------------------------------------------------
  document = imageset.get_document()
  if None == document :
    print "No Document open" 
    return None
  # ------------------------------------------------------------------------------
  store = document.get_store(imageset, objects.Store.DOCUMENT_STORE)
  if None == store :
    print "No Measurements availble" 
    return None
  # ------------------------------------------------------------------------------
  # Get the full object's ID list - if the list's lenght is == 0 no storage 
  # ------------------------------------------------------------------------------
  IdList = store.get_object_ids("")
  #print "lenght " + str(len(IdList))   
  #------------------------------------------------------------------------------  
  if 0 == len(IdList):
    print "No Objects" 
    return None
  # ------------------------------------------------------------------------------
  #print "Get_Storage - OK " 
  return store
# ------------------------------ Script body ----------------------------------- 
# End Function : MA_Get_Storage
# ------------------------------------------------------------------------------
#
# ------------------------------ Script body ----------------------------------- 
# Function : compute_size_boxes
# ------------------------------------------------------------------------------
def compute_size_boxes(imageset,boxes,axes):
  # ------------------------------------------------------------------------------
  # compute the size of boxes in the specified dimension (axes)
  # ------------------------------------------------------------------------------
  width = imageset.get_pixel_width()
  height = imageset.get_pixel_height()
  depth = imageset.get_pixel_depth()
  planeRect = imageset.get_bounding_rectangle()     
  planeCount = imageset.get_plane_count()
  # ------------------------------------------------------------------------------  
  BoxesSize = 1
  # ------------------------------------------------------------------------------  
  if axes == BOX_X:
    #------------------------------------------------------------------------------  
    BoxesSize = planeRect.width 
    if boxes > 0:
      BoxesSize = int(planeRect.width / boxes)
  elif axes == BOX_Y:
    # ------------------------------------------------------------------------------    
    BoxesSize = planeRect.height 
    if boxes > 0:
      BoxesSize = int(planeRect.height / boxes	)
  elif axes == BOX_Z:
    # ------------------------------------------------------------------------------    
    BoxesSize = planeCount 
    if boxes > 0:
      BoxesSize = int(planeCount / boxes)
  else : 
    Boxes = 0
  return BoxesSize 
# ------------------------------ Script body ----------------------------------- 
# End Function : compute_size_boxes
# ------------------------------------------------------------------------------  
# ------------------------------ Script body ----------------------------------- 
# Function : compute_number_boxes
# ------------------------------------------------------------------------------
def compute_number_boxes(imageset,size_um,axes):
  # ------------------------------------------------------------------------------
  # compute the # of boxes in the specified dimension (axes)
  # check if size is bigger than cal * MINIMUM_SIZE_BOX_COEFF
  # size is expressed in um
  # ------------------------------------------------------------------------------
  planeRect = imageset.get_bounding_rectangle()
  planeCount = imageset.get_plane_count()
  # ------------------------------------------------------------------------------  
  width = imageset.get_pixel_width()
  if width <=0.0:
    width = 1.0
  # ------------------------------------------------------------------------------  
  height = imageset.get_pixel_height()
  if height <=0.0:
    height = 1.0
  # ------------------------------------------------------------------------------  
  depth = imageset.get_pixel_depth()
  if depth <=0.0:
    depth = 1.0   
  # ------------------------------------------------------------------------------
  Boxes = 0
  error = 0
  pixels = 0
  BoxesSize = 1
  # ------------------------------------------------------------------------------
  if axes == BOX_X:
    # ------------------------------------------------------------------------------    
    size = int(size_um/width)    
    # ------------------------------------------------------------------------------    
    if size <= width * MINIMUM_SIZE_BOX_COEFF :
      return Boxes
    # ------------------------------------------------------------------------------  
    Boxes = int(float(planeRect.width) / size)
    BoxesSize = planeRect.width 
    if Boxes > 0:
      BoxesSize = planeRect.width / Boxes
    error = float(planeRect.width) - (float(Boxes) * BoxesSize)		
    # ------------------------------------------------------------------------------  
  elif axes == BOX_Y:
    # ------------------------------------------------------------------------------    
    size = int(size_um/height)    
    # ------------------------------------------------------------------------------    
    if size <= height * MINIMUM_SIZE_BOX_COEFF :
      return Boxes
    # ------------------------------------------------------------------------------  
    Boxes = int(float(planeRect.height)/ size)
    BoxesSize = planeRect.height 
    if Boxes > 0:
      BoxesSize = planeRect.height / Boxes
    error = float(planeRect.height) - (float(Boxes) * BoxesSize)	
    # ------------------------------------------------------------------------------  
  elif axes == BOX_Z:
    # ------------------------------------------------------------------------------    
    size = int(size_um/depth)    
    # ------------------------------------------------------------------------------    
    if size <= depth*MINIMUM_SIZE_BOX_COEFF :
      return Boxes
    # ------------------------------------------------------------------------------    
    Boxes = int(float(planeCount) / size)
    BoxesSize = planeCount 
    if Boxes > 0:
      BoxesSize = planeCount / Boxes
    error = float(planeCount) - (float(Boxes) * BoxesSize)	
    # ------------------------------------------------------------------------------    
  else : 
    Boxes = 0
    Boxes = 1
  # ------------------------------------------------------------------------------
  return Boxes
# ------------------------------ Script body ----------------------------------- 
# End Function : compute_number_boxes
# ------------------------------------------------------------------------------  
# ------------------------------ Script body ----------------------------------- 
# Function : compute_boxes
# ------------------------------------------------------------------------------
def compute_boxes(imageset,store):
  # ------------------------------------------------------------------------------    
  if None != imageset and None != store:
    # ------------------------------------------------------------------------------
    # get the numbers of boxes in all the dimension
    # ------------------------------------------------------------------------------
    Xboxes = compute_number_boxes(imageset,SIZE_BOX_X,BOX_X)
    Yboxes = compute_number_boxes(imageset,SIZE_BOX_Y,BOX_Y)
    Zboxes = compute_number_boxes(imageset,SIZE_BOX_Z,BOX_Z)
    # debug
    print "X boxes (#) " + str(Xboxes) + "  Y boxes (#) " + str(Yboxes) + "  Z boxes (#) " + str(Zboxes) 
    #print "X boxes (#) " + str(Xboxes) 
    #print "Y boxes (#) " + str(Yboxes) 
    #print "Z boxes (#) " + str(Zboxes) 
    # debug
    if Xboxes == 0 or Yboxes == 0 or Zboxes==0 :
      print "Error in function -> compute_number_boxes " 
      return False
    # ------------------------------------------------------------------------------
    # get the size of boxes in all the dimension
    # ------------------------------------------------------------------------------
    BoxSizeX = compute_size_boxes(imageset,Xboxes,BOX_X)
    BoxSizeY = compute_size_boxes(imageset,Yboxes,BOX_Y)
    BoxSizeZ = compute_size_boxes(imageset,Zboxes,BOX_Z)
    # debug
    print "X size (pixel) " + str(BoxSizeX) + " Y size (pixel) " + str(BoxSizeY) + " Z size (pixel) " + str(BoxSizeZ) 
    #print "X size (pixel) " + str(BoxSizeX) 
    #print "Y size (pixel) " + str(BoxSizeY) 
    #print "Z size (pixel) " + str(BoxSizeZ) 
    # debug    
    if BoxSizeX == 0 or BoxSizeY == 0 or BoxSizeZ==0 :
      print "Error in function -> compute_size_boxes " 
      return False  
    # ------------------------------------------------------------------------------
    # compute segments and create them inside the active ImageSet
    # ------------------------------------------------------------------------------
    offset = imageset.get_bounding_rectangle()
    planeCount = imageset.get_plane_count()
    # ------------------------------------------------------------------------------  
    for y in range(0, Yboxes) :
      for x in range(0, Xboxes) :
        #------------------------------------------------------------------------------	
        rectLeft = (x * BoxSizeX) + offset.x
        rectTop = (y * BoxSizeY) + offset.y
        #------------------------------------------------------------------------------		
        polyline = [core.Point2D(rectLeft, rectTop), core.Point2D(rectLeft + BoxSizeX, rectTop), core.Point2D(rectLeft + BoxSizeX, rectTop + BoxSizeY), core.Point2D(rectLeft, rectTop + BoxSizeY), core.Point2D(rectLeft, rectTop)]
        polygon = objects.Polygon()
        polygon.set_contour(polyline)
        #------------------------------------------------------------------------------	
        for z in range(0, Zboxes) :
          #------------------------------------------------------------------------------		
          boxTop = z * BoxSizeZ
          boxObject = objects.Segment()
          for innerZ in range(boxTop, boxTop + BoxSizeZ) :
            boxObject.add_polygon(polygon, innerZ)
          store.add_object(boxObject)  
        #------------------------------------------------------------------------------		  
      #objects.StorageObject.set_tags("subVolumes")
  return True
# ------------------------------ Script body ----------------------------------- 
# End Function : compute_boxes
# ------------------------------------------------------------------------------ 
#
#
# ------------------------------ Script body ----------------------------------- 
# Main body
# ------------------------------------------------------------------------------    
print "Script running ...... " 
# helper to get execution time
startTime = time.time()
# ------------------------------------------------------------------------------            
viewer,imageset = MA_Get_Enviroment()
bounds = imageset.get_bounding_rectangle()
print "get_bounding_box " + str(bounds)
# ------------------------------------------------------------------------------            
if None != imageset :
  # ------------------------------------------------------------------------------    
  Store = MA_Get_Storage(imageset)
  risultato = compute_boxes(imageset,Store)  
  # ------------------------------------------------------------------------------            
  if False == risultato: 
    print "Error in function -> compute_boxes " 
# ------------------------------------------------------------------------------            
endTime = time.time()
print "time: " + str(endTime - startTime)
# ------------------------------ Script body ------------------------------ 
# End of main body
# ------------------------------------------------------------------------------    